# 迷路
`Items.Weird_Substance`は、[肥料](docs/unlocks/fertilizer.md)で植物を育てることで得られ、茂みに奇妙な効果をもたらします。ドローンが茂みの上にいるときに `use_item(Items.Weird_Substance, amount)` を呼び出すと、茂みは生垣の迷路に成長します。
迷路のサイズは、使用される`Items.Weird_Substance`の量（`use_item()`呼び出しの2番目の引数）によって異なります。
迷路のアップグレードがない場合、`n`個の`Items.Weird_Substance`を使用すると、`n`x`n`の迷路ができます。各迷路アップグレードレベルは宝物を2倍にしますが、必要な`Items.Weird_Substance`の量も2倍になります。
したがって、フィールドいっぱいの迷路を作るには:

`plant(Entities.Bush)
substance = get_world_size() * 2**(num_unlocked(Unlocks.Mazes) - 1)
use_item(Items.Weird_Substance, substance)`


どういうわけか、ドローンはそれほど高くないように見える生垣の上を飛ぶことができません。

生垣のどこかに宝物が隠されています。宝物に対して `harvest()` を使用すると、迷路の面積に等しいゴールドを受け取ります。（例えば、5x5の迷路は25ゴールドをもたらします。）

他の場所で `harvest()` を使用すると、迷路は単に消えてしまいます。

ドローンが宝物の上にある場合、`get_entity_type()` は `Entities.Treasure` と等しく、迷路の他の場所では `Entities.Hedge` と等しくなります。

迷路には、再利用しない限りループはありません（迷路の再利用については下記を参照）。そのため、ドローンが後戻りせずに同じ場所に戻ることはありません。

壁があるかどうかは、それを通り抜けようとすることで確認できます。
`move()` は成功した場合は `True` を、それ以外の場合は `False` を返します。

`can_move()` を使用すると、移動せずに壁があるかどうかを確認できます。

宝物への行き方がわからない場合は、ヒント1を見てください。このような問題へのアプローチ方法が示されています。

迷路のどこかで `measure()` を使用すると、宝物の位置が返されます。
`x, y = measure()`

さらなる挑戦として、同じ量の`Items.Weird_Substance`を再び宝物に使用することで、迷路を再利用することもできます。
これにより、宝物の中のゴールドの量が迷路1つ分増え、迷路内のランダムな位置に移動します。

宝物が移動するたびに、迷路の壁の一部がランダムに削除されることがあります。そのため、再利用された迷路にはループが含まれることがあります。

迷路にループがあると、戻ることなく同じ場所に再び到達できるため、はるかに難しくなることに注意してください。
迷路を再利用しても、新しい迷路を収穫してスポーンするよりも多くのゴールドが得られるわけではありません。
これは100％追加の挑戦であり、スキップしても構いません。
追加情報とショートカットが迷路をより速く解くのに役立つ場合にのみ価値があります。

宝物は最大300回まで再配置できます。その後、宝物に奇妙な物質を使用しても、中のゴールドは増えなくなり、それ以上移動しなくなります。

<spoiler=show hint 1>問題解決への一般的なアプローチは次のとおりです:

迷路を作成し、自分がドローンであると想像してください。

もし自分が迷路にいたら、どのようにして宝物を見つけようとするか考えてみてください。

あなたの戦略を、他の誰かが考えずに従えるように、ステップバイステップで書き留めてください。

次に、あなたのステップをコードに翻訳してみてください。
</spoiler>
<spoiler=show hint 2>ループがない限り: すべての壁は実際には1つの大きなつながった壁です。壁に沿って進むと、迷路全体を通り抜けることになります。
このアプローチは非常に少ないコードで済み、すでにどこにいたかを追跡する必要はありません。約10行のコードで十分です。</spoiler>
<spoiler=show hint 3>ドローンを東や西のような絶対的な方向に動かす代わりに、「右に曲がる」や「左に曲がる」のような相対的な方向に動かすと非常に便利です。これを行うには、ドローンが現在どちらの方向に動いているかを追跡する必要があります。ドローンは実際には回転しませんが、コード内で「仮想的」な回転を維持することができます。
次のインデックストリックが役立ちます:

`directions = [North, East, South, West]
index = 0`

`% 4` を使用して、「円の周り」を回転できるようにし、`West` の後に `North` にラップバックするようにします。
`# 右に曲がる
index = (index + 1) % 4`

`# 左に曲がる
index = (index - 1) % 4

move(directions[index])`</spoiler>
<spoiler=show hint 4>もし解けない場合は、いつでも楽をして効率の悪い方法でやることができます。
`1`x`1`の迷路を解くのは簡単です。</spoiler>